// SAOpenInstTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SAOpenInstTest.h"
#include "SAOpenInstTestDlg.h"
#include "StringHelper.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CSAOpenInstTestDlg dialog



CSAOpenInstTestDlg::CSAOpenInstTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSAOpenInstTestDlg::IDD, pParent)
	, m_Collection(_T(""))
	, m_Group(_T("Main"))
	, m_Target(_T("P0"))
	, m_XPos(0)
	, m_YPos(0)
	, m_ZPos(0)
	, m_XUncert(0)
	, m_YUncert(0)
	, m_ZUncert(0)
	, m_ProbeRadius(0)
	, m_NumMeasurements(0)
	, m_CloudName(_T(""))
	, m_CloudXPos(0)
	, m_CloudYPos(0)
	, m_CloudZPos(0)
	, m_NumCloudPoints(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSAOpenInstTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_COLLECTION_EDIT, m_Collection);
	DDX_Text(pDX, IDC_GROUP_EDIT, m_Group);
	DDX_Text(pDX, IDC_TARGET_EDIT, m_Target);
	DDX_Text(pDX, IDC_XPOS_EDIT, m_XPos);
	DDX_Text(pDX, IDC_YPOS_EDIT, m_YPos);
	DDX_Text(pDX, IDC_ZPOS_EDIT, m_ZPos);
	DDX_Text(pDX, IDC_XUNCERT_EDIT, m_XUncert);
	DDX_Text(pDX, IDC_YUNCERT_EDIT, m_YUncert);
	DDX_Text(pDX, IDC_ZUNCERT_EDIT, m_ZUncert);
	DDX_Text(pDX, IDC_PROBERADIUS_EDIT, m_ProbeRadius);
	DDX_Control(pDX, IDC_COLLECTION_EDIT, m_collectionEditCtrl);
	DDX_Control(pDX, IDC_GROUP_EDIT, m_groupEditCtrl);
	DDX_Control(pDX, IDC_TARGET_EDIT, m_targetEditCtrl);
	DDX_Control(pDX, IDC_XPOS_EDIT, m_XPosEditCtrl);
	DDX_Control(pDX, IDC_YPOS_EDIT, m_YPosEditCtrl);
	DDX_Control(pDX, IDC_ZPOS_EDIT, m_ZPosEditCtrl);
	DDX_Control(pDX, IDC_XUNCERT_EDIT, m_XUncertEditCtrl);
	DDX_Control(pDX, IDC_YUNCERT_EDIT, m_YUncertEditCtrl);
	DDX_Control(pDX, IDC_ZUNCERT_EDIT, m_ZUncertEditCtrl);
	DDX_Control(pDX, IDC_PROBERADIUS_EDIT, m_ProbeRadiusEditCtrl);
	DDX_Control(pDX, IDC_CLEARMEASUREMENTS_BUTTON, m_ClearMeasBtnCtrl);
	DDX_Control(pDX, IDC_ADDMEASUREMENTS_BUTTON, m_AddMeasBtnCtrl);
	DDX_Control(pDX, IDC_SENDMEASUREMENT_BUTTON, m_SendMeasBtnCtrl);
	DDX_Control(pDX, IDC_LOGON_BUTTON, m_LogonBtnCtrl);
	DDX_Control(pDX, IDC_CLOUDNAME_EDIT, m_cloudNameEditCtrl);
	DDX_Control(pDX, IDC_XPOS_CLOUD_EDIT, m_cloudXPosEditCtrl);
	DDX_Control(pDX, IDC_YPOS_CLOUD_EDIT, m_cloudYPosEditCtrl);
	DDX_Control(pDX, IDC_ZPOS_CLOUD_EDIT, m_cloudZPosEditCtrl);
	DDX_Control(pDX, IDC_CLEARCLOUD_BUTTON, m_clearCloudBtnCtrl);
	DDX_Control(pDX, IDC_ADDCLOUDPOINT_BUTTON, m_addCloudBtnCtrl);
	DDX_Control(pDX, IDC_SENDCLOUD_BUTTON, m_sendCloudBtnCtrl);
	DDX_Control(pDX, IDC_RANDOMCLOUDPOINT_BUTTON, m_randomCloudBtnCtrl);
	DDX_Text(pDX, IDC_CLOUDNAME_EDIT, m_CloudName);
	DDX_Text(pDX, IDC_XPOS_CLOUD_EDIT, m_CloudXPos);
	DDX_Text(pDX, IDC_YPOS_CLOUD_EDIT, m_CloudYPos);
	DDX_Text(pDX, IDC_ZPOS_CLOUD_EDIT, m_CloudZPos);
	DDX_Control(pDX, IDC_SAOPENINSTCTRL1, m_SAOpenInstCtrl);
}

BEGIN_MESSAGE_MAP(CSAOpenInstTestDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_LOGON_BUTTON, OnBnClickedLogonButton)
	ON_BN_CLICKED(IDC_SENDMEASUREMENT_BUTTON, OnBnClickedSendmeasurementButton)
	ON_BN_CLICKED(IDC_CLEARMEASUREMENTS_BUTTON, OnBnClickedClearmeasurementsButton)
	ON_BN_CLICKED(IDC_ADDMEASUREMENTS_BUTTON, OnBnClickedAddmeasurementsButton)
	ON_BN_CLICKED(IDC_CLEARCLOUD_BUTTON, OnBnClickedClearcloudButton)
	ON_BN_CLICKED(IDC_ADDCLOUDPOINT_BUTTON, OnBnClickedAddcloudpointButton)
	ON_BN_CLICKED(IDC_SENDCLOUD_BUTTON, OnBnClickedSendcloudButton)
	ON_BN_CLICKED(IDC_RANDOMCLOUDPOINT_BUTTON, OnBnClickedRandomcloudpointButton)
END_MESSAGE_MAP()


// CSAOpenInstTestDlg message handlers

BOOL CSAOpenInstTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	SetButtons(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSAOpenInstTestDlg::SetButtons(const BOOL& active)
{
	m_LogonBtnCtrl.EnableWindow(!active);
	m_collectionEditCtrl.EnableWindow(active);
	m_groupEditCtrl.EnableWindow(active);
	m_targetEditCtrl.EnableWindow(active);
	m_XPosEditCtrl.EnableWindow(active);
	m_YPosEditCtrl.EnableWindow(active);
	m_ZPosEditCtrl.EnableWindow(active);
	m_XUncertEditCtrl.EnableWindow(active);
	m_YUncertEditCtrl.EnableWindow(active);
	m_ZUncertEditCtrl.EnableWindow(active);
	m_ProbeRadiusEditCtrl.EnableWindow(active);
	m_ClearMeasBtnCtrl.EnableWindow(active);
	m_AddMeasBtnCtrl.EnableWindow(active);
	m_SendMeasBtnCtrl.EnableWindow(active);
	m_cloudNameEditCtrl.EnableWindow(active);
	m_cloudXPosEditCtrl.EnableWindow(active);
	m_cloudYPosEditCtrl.EnableWindow(active);
	m_cloudZPosEditCtrl.EnableWindow(active);
	m_clearCloudBtnCtrl.EnableWindow(active);
	m_addCloudBtnCtrl.EnableWindow(active);
	m_sendCloudBtnCtrl.EnableWindow(active);
	m_randomCloudBtnCtrl.EnableWindow(active);
}

void CSAOpenInstTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSAOpenInstTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSAOpenInstTestDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}
BEGIN_EVENTSINK_MAP(CSAOpenInstTestDlg, CDialog)
	ON_EVENT(CSAOpenInstTestDlg, IDC_SAOPENINSTCTRL1, 5, OnSetColGroupTargetSaopeninstctrl1, VTS_BSTR VTS_BSTR VTS_BSTR)
END_EVENTSINK_MAP()

void CSAOpenInstTestDlg::OnBnClickedLogonButton()
{
	SetButtons(m_SAOpenInstCtrl.PopLogonDialog());
}

void CSAOpenInstTestDlg::OnBnClickedSendmeasurementButton()
{
	UpdateData(TRUE);
	BOOL status;
	if (status = m_SAOpenInstCtrl.SendMeasurements(m_Collection, m_Group, m_Target, m_ProbeRadius, m_ProbeRadius))
	{
		StringHelper::IncrementName(m_Target, m_NumMeasurements);
		UpdateData(FALSE);
	}
	MessageBeep((status)? MB_ICONEXCLAMATION : MB_ICONHAND);
}

void CSAOpenInstTestDlg::OnBnClickedClearmeasurementsButton()
{
	m_SAOpenInstCtrl.ClearMeasurements();
	m_NumMeasurements = 0;
}

void CSAOpenInstTestDlg::OnBnClickedAddmeasurementsButton()
{
	UpdateData(TRUE);

	m_NumMeasurements++;
	m_SAOpenInstCtrl.AddMeasurement( m_XPos, m_YPos, m_ZPos, m_XUncert, m_YUncert, m_ZUncert);
	MessageBeep(MB_OK);
}

void CSAOpenInstTestDlg::OnSetColGroupTargetSaopeninstctrl1(LPCTSTR collectionName, LPCTSTR groupName, LPCTSTR targetName)
{
	m_Collection = collectionName;
	m_Group		 = groupName;
	m_Target	 = targetName;
	UpdateData(FALSE);
}

void CSAOpenInstTestDlg::OnBnClickedClearcloudButton()
{
	m_SAOpenInstCtrl.ClearCloud();
	m_NumCloudPoints = 0;
}

void CSAOpenInstTestDlg::OnBnClickedAddcloudpointButton()
{
	UpdateData(TRUE);

	m_NumCloudPoints++;
	m_SAOpenInstCtrl.AddCloudPoint( m_XPos, m_YPos, m_ZPos);
	MessageBeep(MB_OK);
}

void CSAOpenInstTestDlg::OnBnClickedSendcloudButton()
{
	UpdateData(TRUE);
	BOOL status;
	if (status = m_SAOpenInstCtrl.SendCloud(m_CloudName, _T("")))
	{

	}
	MessageBeep((status)? MB_ICONEXCLAMATION : MB_ICONHAND);
}

void CSAOpenInstTestDlg::OnBnClickedRandomcloudpointButton()
{
	// The number of points to be generated...
	int num = 10000;

	// x / y / z ranges...
	double xmin = -10.0;
	double ymin = -10.0;
	double zmin = -10.0;
	double xmax = 10.0;
	double ymax = 10.0;
	double zmax = 10.0;

	double x, y, z;
	double xdiff, ydiff, zdiff;
	for (int i=0;i<num;i++)
	{
		x = ((double)rand())/((double)RAND_MAX);
		y = ((double)rand())/((double)RAND_MAX);
		z = ((double)rand())/((double)RAND_MAX);
		xdiff = xmax - xmin;
		ydiff = ymax - ymin;
		zdiff = zmax - zmin;
		xdiff *= x;
		ydiff *= y;
		zdiff *= z;
		x = xmin + xdiff;
		y = ymin + ydiff;
		z = zmin + zdiff;
		m_SAOpenInstCtrl.AddCloudPoint( x, y, z);
		m_NumCloudPoints++;
	}
	MessageBeep(MB_OK);
}
